// Collision Detection



#declare shapes2=
// fluted and helical ring shapes
isosurface {
 function { 1-                            
  //min ( // for merge
  //max ( // for intersection and difference
  //sqrt((x*x)+(z*z))-y // cone
  sqrt((x*x)+(y*y)+(z*z))*1.0 // sphere 
  //sqrt((x*x)+(z*z))*1.0 // cylinder
  //sqrt((x*x)+(z*z))*y*1.0 // trumpet
  //)// min
  //-(x/2) // skew
  //
  //surface modifier
  //
  //-sin ( atan2(x,z)*30)*0.02 // fluting 
  //-sin ( atan2(x,z)*5)*0.1 // fluting 5 wave
  //-sin (y*2*pi*2)*0.1 //*0.05 // rings
  -sin ( (y*2*pi*2) + (atan2(x,z)*4) ) *0.05 // normal helical
 }
 threshold 0
 //contained_by { box{<-4,-4,-4>,< 4, .7, 4> }  }
 contained_by {sphere {0,1.2}}
 open
 max_gradient 3
 scale 0.3
}



#declare shapes1=
union {
sphere { 0,1 scale <0.3,0.5,0.7> }
sphere { 0,1 scale <0.7,0.5,0.3> }
}

#declare many_shapes=                 
object { shapes 
 pigment { rgb 1 }
 finish { ambient 0.5 }
 scale 1
 rotate -30*x 
 translate <0,ht,ds>
}
// object { many_shapes }

#macro record_position (an_object,idx)
 #declare collid [idx][0]=min_extent(an_object);
 #declare collid [idx][1]=max_extent(an_object);
 #declare countob=countob+1;
#end

#macro check_free_position (pmin,pmax,hit ) 
 #local ii=0;
 #local hit=-1;
 #while (ii<countob)
  #if (((pmin.x>=collid [ii][0].x) & (pmin.x<=collid [ii][1].x)) 
  |  ((pmax.x>=collid [ii][0].x) & (pmax.x<=collid [ii][1].x)))
   #if (((pmin.y>=collid [ii][0].y) & (pmin.y<=collid [ii][1].y))
   | ((pmax.y>=collid [ii][0].y) & (pmax.y<=collid [ii][1].y)))
    #if (((pmin.z>=collid [ii][0].z) & (pmin.z<=collid [ii][1].z))
    | ((pmax.z>=collid [ii][0].z) & (pmax.z<=collid [ii][1].z)))
     #local hit=ii;
    #end // if
   #end // if
  #end // if   
  #local ii=ii+1;
  #if (hit>=0) #local ii=countob; #end // early exit
 #end // while
#end // macro


/////////////////////////////////////////////////////////


#macro generate_locations_and_place_objects 
 ( nexte,req_amount,maxtrials,bounding_shape,obj,minbox,maxbox )
 // this macro requires random seeded variable rr and
 // array collid [collid_size][2]
 // parameters:
 // nexte      first entry in the collid array
 // amount     number of entries required
 // maxtrials  max number of trials before giving up
 // bounding_shape to contain the objects
 // minbox maxbox bounding box of objects to be placed
 // on completion:
 // nexte  returns next available entry in collid array
 // amount returns unsuccessful placements remaining
 #local minbound=min_extent(bounding_shape);
 #local maxbound=max_extent(bounding_shape);
 #local amount=req_amount;
 #local trials=0;
 #local exit_trials=0; 
 #if (nexte>=collid_size) #local exit_trials=1; #end
 #if (nexte+amount>collid_size) #local amount=collid_size-start; #end
 #if (amount<1); #local exit_trials=1; #end
 //
 #while (exit_trials=0)
  #local ii=0;
  #local hit=-1;
  // trying a random position within the bounding box or surface
  // boundaries of the object do not exceed the boundaries of the field
  #local try=
  <
  //minbound.x-minbox.x + (rand(rr)*(maxbound.x-minbound.x+minbox.x-maxbox.x)),
  //minbound.y-minbox.y + (rand(rr)*(maxbound.y-minbound.y+minbox.y-maxbox.y)),
  //minbound.z-minbox.z + (rand(rr)*(maxbound.z-minbound.z+minbox.z-maxbox.z))
  minbound.x+(rand(rr)*(maxbound.x-minbound.x)),
  minbound.y+(rand(rr)*(maxbound.y-minbound.y)),
  minbound.z+(rand(rr)*(maxbound.z-minbound.z))
  >;
  #local on_surf=1; // drop parallel to z axis
  #if (on_surf>0)
   #local try=<try.x,100,try.z>; // pull back
   #local Norm = <0, 0, 0>;
   #local Norm1= <0, 0, 0>;
   #local Start=try;
   #local Aim=<try.x,-100,try.z>;
   #local surf=object { bounding_shape scale (maxbound-maxbox)/maxbound }    
   #local Inter= trace ( bounding_shape, Start, Aim-Start, Norm );
   #if (vlength(Norm)=!0)
    #local try=<try.x,try.y,Inter.z>; // successful landing but check further
    #local try=<try.x,Inter.y,try.z>; // successful landing but check further
    #local Inter= trace ( surf, Start, Aim-Start, Norm1 );
    #if (vlength(Norm1)=0)
     //#local hit=ii; #local ii=nexte; // reject because too close to edge   
    #end
   #else
    #local hit=ii; #local ii=nexte; // reject because off the bounding shape  
   #end // if Norm
  #end // if on_surf
  #local pmin=try+minbox;
  #local pmax=try+maxbox;
  #local within_shape=0;
  #if (within_shape>0)
   #local Norm = <0, 0, 0>;
   #local Start=try;
   #local Aim=0.5*(minbound+maxbound);
   #local surf=object { bounding_shape scale (maxbound-maxbox)/maxbound } 
   #local Inter= trace ( surf, Start, Aim-Start, Norm );
   #if (vlength(Norm)=!0)
     trace was successful, a Surface intersection located
    //#local pp=CtrlPtrn ( Inter.x, Inter.y, Inter.z );
    //#if (pp>0.5)
    //#else
    //#end //if
    // test for outsidedness
    #local su=0;
    #if ((Aim.x<=Inter.x) & (Inter.x<=Start.x)) #local su=su+1; #end 
    #if ((Aim.y<=Inter.y) & (Inter.y<=Start.y)) #local su=su+1; #end
    #if ((Aim.z<=Inter.z) & (Inter.z<=Start.z)) #local su=su+1; #end
    #if ((Aim.x>=Inter.x) & (Inter.x>=Start.x)) #local su=su+1; #end 
    #if ((Aim.y>=Inter.y) & (Inter.y>=Start.y)) #local su=su+1; #end
    #if ((Aim.z>=Inter.z) & (Inter.z>=Start.z)) #local su=su+1; #end
    #if (su>2)
     #local hit=ii; #local ii=nexte; 
     // the tracer ray hit the surface so
     // the try was outside the bounding_shape
    #end // if su outsided
   #end // if Norm
  #end // if within shape
  // check that object does not collide with others in the array
  // bounding box intersection tests
  #while (ii<nexte)
   #if (((pmin.x>=collid [ii][0].x) & (pmin.x<=collid [ii][1].x)) 
   |  ((pmax.x>=collid [ii][0].x) & (pmax.x<=collid [ii][1].x)))
    #if (((pmin.y>=collid [ii][0].y) & (pmin.y<=collid [ii][1].y))
    | ((pmax.y>=collid [ii][0].y) & (pmax.y<=collid [ii][1].y)))
     #if (((pmin.z>=collid [ii][0].z) & (pmin.z<=collid [ii][1].z))
     | ((pmax.z>=collid [ii][0].z) & (pmax.z<=collid [ii][1].z)))
      #local hit=ii; // collision
     #end // if z
    #end // if y
   #end // if x  
   #local ii=ii+1;
   #if (hit>=0) #local ii=nexte; #end // early exit
  #end // while
  #if (hit<0)
   // no hits so add to list
   #declare collid [nexte][0]=try+minbox;
   #declare collid [nexte][1]=try+maxbox;
   // now place the object
   //object { obj // fixed objects
   union { make_shapes() // individualised objects
    rotate rand(rr)*360*y
    #local vt=<0,maxbox.y-minbox.y,0>; // vertical component
    Point_At_Trans ( Norm+vt ) // partial surface alignment 
    scale <rand(rr)/5+0.8,rand(rr)/5+0.8,rand(rr)/5+0.8>
    translate try // assuming zero base
   }
   #local nexte=nexte+1;
   #local amount=amount-1;
   #local req_amount=req_amount-1;
   #if (amount<1) #local exit_trials=1; #end
  #end // if no hit
  #if (nexte>=collid_size) #local exit_trials=1; #end
  #local trials=trials+1;
  #if (trials>maxtrials) #local exit_trials=1; #end
 #end // while trials
#end // macro


//////////////////////////////////////////////////


#macro place_objects_from_array (nexte,amount,obj)
 #local ii=nexte;
 #local ee=nexte+amount;
 #while (ii<ee)
  object { obj
   scale <rand(rr)/5+0.8,rand(rr)/5+0.8,rand(rr)/5+0.8>
   //rotate <rand(rr)*360, rand(rr)*360, rand(rr)*360>
   //rotate (rand(rr)*60-30)*z
   rotate rand(rr)*360*z
   //rotate-90*x
   translate (collid [ii][0]+collid [ii][1])*0.5 // average of min max extents
   translate -(collid [ii][0].z+collid [ii][1].z)*0.5*z  // for 0 origin objects
   // texture { spotty_toadstool_tex }
   // pigment { rgb < rand(rr)/4+0.8, rand(rr)/4+0.8, rand(rr)/4+0.6 > }
   //normal { bumps 1 scale 0.002}
   finish { ambient 0.4 }
  }
  #local ii=ii+1;
 #end // while 
#end // macro

//////////////////////////////////////////////////

#declare rr=seed(3456);
#declare collid_size=300;
#declare collid = array [collid_size][2]
#declare countob=0;
#declare hit=0;
record_position (many_shapes,0)
// and any other objects to be avoided

#declare xx=0; #declare yy=ht+1.1; #declare zz=ds; // position to try
#declare min_pos=<xx,yy,zz>;
#declare max_pos=<xx,yy,zz>;

#declare boundary_shape=
//merge {
 sphere {0,3 scale <2,0.3,2> }
// sphere {0,4 scale <1.5,1.5,0.8> translate -5*x }
// sphere {0,4 scale <1,1.5,1> translate  5*x }
//}

#declare amt=200;          
#declare next_entry=0;

/////////////////////////////////////////////////////


union {

// ( nexte, req_amount, maxtrials, bounding_shape, obj, minbox, pmaxbox )
generate_locations_and_place_objects ( next_entry,amt,amt*3,
 boundary_shape, shapes,
 minshapes,
 maxshapes )
 //                             
 object { boundary_shape 
 pigment { rgbt  <1,1,0.7,0>*0.6 } 
 normal {granite 0.2 scale 0.7  }
 finish {ambient 0.5} 
}
//#declare amt=next_entry; // the number of objects successfully placed
//place_objects_from_array(0,amt,shapes)
scale 1.2
rotate -10*x
translate <0,ht,ds>
pigment { rgbt <1,1,1,0.0> }
finish { ambient 0.4 }
}




//////////////////////////////////////////////////////

#macro test_placement()
check_free_position (min_pos,max_pos,hit)
#if (hit<0)
 // place object
 cone { <xx,yy,zz>,1,<xx,yy+2,zz>,0 pigment {Green} }
#else
 // dont place or try another position
#end
#end // macro                       
                       
#declare 
display_extents=
union {
cylinder { collid[0][0],collid [0][1],.1 }
sphere { collid[0][0],0.5 pigment { Blue } }
sphere { collid[0][1],0.5 }
}



